 LST OFF
*
* MARINA - BY D. FINNIGAN - 01 AUG 2016
*
DEBUG EQU 0
MULTICAST EQU 1
ENABLEDNS EQU 1
DEMOUI EQU 1
*
* MONITOR EQUATES
CROUT EQU $FD8B
COUT EQU $FDED
WAIT EQU $FCA8
DOSWARM EQU $3D0
PRNTAX EQU $F941
PRBYTE EQU $FDDA
GETLN EQU $FD6A
*
KBD EQU $C000
KBDSTRB EQU $C010
ESC EQU $9B
*
RNDL EQU $4E
RNDH EQU $4F
*
ETHHLEN EQU 14 ; LENGTH OF ETHERNET HEADER
*
* PROTOCOL NUMBERS
*
PROTOICMP EQU 1
PROTOTCP EQU 6
PROTOUDP EQU 17
*
* OUTGOING PACKET USER DATA STORED AT $5600
*
OUTPDAT EQU $5600
OUTPBUF EQU $18 ; POINTER TO BUFFER (2 BYTES)
OUTPLEN EQU $1A ; LENGTH OF OUTGOING PACKET DATA
OUTPHLEN EQU $4C ; 1-BYTE LEN OF PROTOCOL HEADERS
*
* INCOMING PACKETS - ZERO-PAGE LOCATIONS
INPBUF EQU $08 ; POINTER TO BUFFER (2 BYTES)
INPLEN EQU $06 ; LENGTH OF INCOMING PACKET DATA
*
PTR EQU $0A ; GENERAL PURPOSE POINTER
PTR2 EQU $1C ; 2ND GENERAL PURPOSE POINTER
*
* COUNT OF INCOMING IP DATAGRAMS
IPCOUNT EQU $0C ; A TWO-BYTE COUNTER
*
* SOME USEFUL THINGS TO KNOW ABOUT IP PACKETS
*
IPHEADLEN EQU $0E ; THIS IS THE LENGTH OF THE HEAD, USUALLY 20
CHKSUM EQU $0F ; TWO BYTES TO HOLD A COMPUTED CHECKSUM
CHKSUMLEN EQU $1E ; LENGTH OF DATA TO CHECKSUM
*
* IP CONFIGURATION MODE:
* 0 = LINK-LOCAL (DEFAULT)
* 2 = DHCP
* 4 = STATIC
* MSB SET = SUCCESSFUL CONFIGURATION
*
IPCONFMODE EQU $15 ; HOW OUR IP ADDRESS WAS CONFIGURED
*
* TWO COUNTERS FOR ADDRESS CONFLICT DETECTION
PROBENUM EQU $16 ; NUMBER OF PROBE PACKETS (TYPICALLY 3)
ANNNUM EQU $17 ; NUMBER OF ANNOUNCEMENT PACKETS (2)
*
 ORG $6000
*
* PROGRAM START
*
 CLD
 CLC
*
* DUE TO HOW THE PRODOS GET_PREFIX CALL WORKS, THE RANDOM
* SEED IS ALWAYS SET TO A CONSTANT. THAT'S BAD, SO WE NEED
* TO HAVE THIS CALL TO GETLN TO RANDOMIZE IT ONCE MORE.
*
 JSR GETLN ; SEE ALSO NOTE IN IPCONFIG
 LDY #0
:L LDA MSG1,Y
 BEQ :FINDCARD
 JSR COUT
 INY
 BNE :L
:FINDCARD
 JSR ETHFIND ; WILL EXIT TO DOS IF NOT FOUND
 LDA #0
 STA IPCOUNT ; INITIALIZE THE COUNTER
 STA IPCOUNT+1
 STA IPCONFMODE
 STA PROBENUM
 STA ANNNUM
*
* INITIALIZE VARIOUS SUB-SYSTEMS
*
 JSR ARPINIT
 JSR DHCPINIT
 DO ENABLEDNS
 JSR DNSINIT
 FIN
 JMP MAINLOOP ; NOW WE ARE OFF!
*
*
* THIS IS THE MAIN LOOP THAT LISTENS FOR INCOMING PACKETS,
* AND IF THERE IS ONE, IT WILL COPY IT TO THE APPLE'S RAM
* AND DECIDE WHAT TO DO ABOUT IT.
*
MAINLOOP
 LDA IPCONFMODE ; DO WE HAVE AN ADDRESS CONFIGURED?
 BPL :CHECKDHCP ; NO ADDRESS CONFIGURED
 CMP #%10000000 ; LL WITH PERIODIC DHCP DISCOVERIES?
 BNE :CHKANN ; NO, SO MOVE ON
* A LINK-LOCAL ADDRESS IS CONFIGURED, BUT WE WILL SEND
* PERIODIC DHCP DISCOVERIES TO CONFIGURE A ROUTABLE
* ADDRESS. UNTIL WE HAVE A REAL TIMER, WE WILL USE
* RNDL TO SPACE OUT DISCOVERIES.
 LDA DHCPSTAT
 BNE :CHKANN ; MOVE ON
 LDA RNDL
 AND #%00000111
 CMP #%00000101
 BNE :CHKANN ; TRY LATER
* DO NOT SEND DHCP DISCOVERY IF WAITING ON ARP
 LDA ARPTRIES
 BNE :CHKANN ; TRY LATER
 INC RNDL
 LDA #$FF
 JSR WAIT
 LDA RNDL
 JSR WAIT
 JSR DHCPSENDDISC
 LDA #$FF
 JSR WAIT
 BEQ :CHKANN ; ALWAYS TAKEN
* CHECK IF WE NEED TO SEND OUT OUR INITIAL DHCP
* DISCOVERY MESSAGES. IF THIS IS 0, THEN CONFIGURE
* A LINK-LOCAL ADDRESS.
:CHECKDHCP
 LDA DHCPSTAT ; ARE WE IN DISCOVERY MODE?
 BNE :CHKANN ; NO, SO MOVE ON
* DON'T CALL IPCONFIG AGAIN IF WE'RE SENDING OUT PROBES
 LDA PROBENUM ; SHOULD BE 0
 ORA ANNNUM
 BNE :CHKANN
 LDA DHCPDINUM ; MORE DISCOVERIES TO SEND?
 BNE :SENDDHCPDI ; YES, SEND.
* IF WE GET HERE, THEN WE ARE NOT SENDING ARP PROBES AND
* THERE ARE NO MORE INITIAL DHCP DISCOVERIES TO SEND, SO
* START CONFIGURING A LINK-LOCAL ADDR.
 JSR IPCONFIG
 JMP :CHKANN
:SENDDHCPDI
 LDA #$FF
 JSR WAIT
 JSR DHCPSENDDISC
 LDA #$FF
 JSR WAIT
 LDA #$FF
 JSR WAIT
 DEC DHCPDINUM
*
:CHKANN LDA PROBENUM ; DO WE NEED TO SEND ARP PROBE?
 BEQ :ANNOUNCE ; NO MORE PROBES NEEDED.
 LDA RNDL
 JSR WAIT
 LDA RNDL
 JSR WAIT
 LDA #$FF
 JSR WAIT
 JSR ARPPROBE ; SEND A PROBE PACKET
 DEC PROBENUM ; REDUCE THE PROBE COUNT
 INC RNDL
 BNE :POLL
 INC RNDH
 LDA RNDH
 JSR WAIT
 BEQ :POLL ; ALWAYS TAKEN
:ANNOUNCE
 LDA ANNNUM ; CHECK FOR ARP ANNOUNCEMENTS NEEDED
 BEQ :POLL ; NO MORE ANNOUNCEMENTS NEEDED
 LDA RNDH
 JSR WAIT
 LDA RNDH
 JSR WAIT
 LDA #$FF
 JSR WAIT
 JSR ARPANNOUNCE ; SEND ANNOUNCEMENT PACKET
 DEC ANNNUM
 LDA ANNNUM ; SENT LAST ANNOUNCEMENT?
 BNE :POLL ; NO, MORE TO SEND LATER
* MARK IP CONFIGURATION AS SUCCESSFUL
 LDA IPCONFMODE
 ORA #%10000000
 STA IPCONFMODE
 DO DEBUG
 LDY #0
:ANL LDA MSG14,Y
 BEQ :PRIPADDR
 JSR COUT
 INY
 BNE :ANL
:PRIPADDR
 LDA #<IPADDR
 STA PTR
 LDA #>IPADDR
 STA PTR+1
 JSR PRNTIPDEC
* PRINT ROUTER
 LDY #0
:ANL2 LDA MSG16,Y
 BEQ :PRROUTER
 JSR COUT
 INY
 BNE :ANL2
:PRROUTER
 LDA #<ROUTER
 STA PTR
 LDA #>ROUTER
 STA PTR+1
 JSR PRNTIPDEC
 FIN
* SEND ARP REQUEST FOR OUR ROUTER, IF ANY
 LDA IPCONFMODE
 AND #%10000010 ; DHCP CONFIGURATION
 CMP #%10000010
 BNE :POLL ; LINK-LOCAL CONFIGURATION
 LDA #<ROUTER
 STA PTR
 LDA #>ROUTER
 STA PTR+1
 JSR ARPREQUEST
*
*
:POLL JSR ETHINPOLL ; CHECK FOR A PACKET
 BCS :RESEND
 JMP PROCESS ; GOT ONE!
:RESEND   ; NEED TO RESEND A DATAGRAM?
 LDA ARPTRIES
 BEQ :NOARP ; NO, NOTHING WAITING ON ARP
 JSR IPSEND2
*
* HERE IS WHERE WE WOULD ADD AN RTS TO TURN MARINA INTO
* A POLLED-ACCESS IP STACK CALLED FROM A REAL PROGRAM.
* FOR INTERFACES THAT SUPPORT IRQ, SUCH AS SUPER SERIAL
* OR THE UTHERNET II, MARINA COULD RUN AS A BACKGROUND
* TASK, RESPONDING TO INCOMING IP DATAGRAMS IN REAL TIME.
*
 NOP ; RTS
*
*
:NOARP   ; GO STRAIGHT TO DEMO UI
*
*
*
 DO DEMOUI
 PUT /MARINA/DEMO.UI
 FIN

 PUT /MARINA/INCOMING
 PUT /MARINA/MESSAGES
 PUT /MARINA/SOCK
 PUT /MARINA/IPCONFIG
 PUT /MARINA/ICMP
 PUT /MARINA/IP
 PUT /MARINA/UDP
 PUT /MARINA/TCB
 PUT /MARINA/TCP
 PUT /MARINA/TCPOUT
* PUT /MARINA/ETH
 PUT /MARINA/UTH2
* PUT /MARINA/SLIP
 PUT /MARINA/ARP
 PUT /MARINA/DHCP
 PUT /MARINA/MISC
 DO ENABLEDNS
 PUT /MARINA/DNS
 FIN
* PUT CLOCK,D2
